package super_simple.instruction.set;



public class input {

	public static String[] used_label = new String[set.assembler_total_length];	//使用済みラベル名を保存しておく。エラー処理用
	
	// check_used_label():使用済みラベルかどうかをチェックする関数 input(), input_b()で使用
	public static void check_used_label(String now_label, int now_line){
		if(now_label.compareTo("") > 0 ){
			for(int i = 0; i<set.assembler_total_length ; i++){
		
				if(now_label.equals(used_label[i])){	// 使用済みラベルとかぶっていた場合
					main.error(now_label + " は既に使用済みのラベルです", now_line);
					set.check_flag=1;
				}else{
						
				}
			}
			int j=0;
			while(used_label[j].compareTo("ありえないかずとか")>0 && j<256){
				j++;
			}
			used_label[j] = now_label;
		}
	}	// check_used_label()ここまで
	

	/* ここからオペランド判定用関数。レジスタかメモリか即値か。 */
	
	// 渡されたオペランド（文字列）がレジスタかチェックする関数。レジスタなら return 1, それ以外なら return -1;
	public static int check_register(String operand){
		if(operand.compareTo("R0")== 0 	
			|| operand.compareTo("R1")== 0 
			|| operand.compareTo("R2")== 0 
			|| operand.compareTo("R3")== 0 ){
				return 1;	// R0 ~ R3のいずれかなら return 1
		}else{
			set.check_flag=2;
			return -1;	// レジスタじゃなければ　return -1;
		}
	}	// check_register()ここまで
			
	
	
	// 渡されたオペランド（文字列）が即値かチェックする関数。即値なら return 1, それ以外なら return -1;
	public static int check_immediate_data(String operand){
		if(operand.indexOf("#") == 0){	//1文字目が#なら即値
			return 1;
		}else{
			set.check_flag=3;
			return -1;
		}
	}	// check_immediate_date()ここまで
	
	

	
	// 渡されたオペランドが M(Rd) かチェックする関数。M(Rd)ならreturn 1,それ以外ならretuen -1;
	public static int check_memory_Rd(String operand){
		if(operand.compareTo("M(R0)") == 0 || 
		   operand.compareTo("M(R1)") == 0 || 
		   operand.compareTo("M(R2)") == 0 || 
		   operand.compareTo("M(R3)") == 0 ){
			return 1;
		}else{
			
			return -1;
		}
	}	// check_memory_Rd()ここまで
	
	// 渡されたオペランドが M(address) かチェックする関数。M(address)ならreturn 1,それ以外ならretuen -1;
		public static int check_memory_ad(String operand){
			if(operand.indexOf("M(") == 0 && operand.indexOf(")") == (operand.length() -1)){	// 必ず『M(#』 で始まり『)』で終わる
				return 1;
			}else{
				set.check_flag=5;
				return -1;
			}
		}	// check_memory_im() ここまで
	
	// check_memory_Rd_im(): オペランドがM(Rd+#n)かチェックする関数。M(Rd+#n)ならreturn 1,それ以外ならreturn -1;
	public static int check_memory_Rd_im(String operand){
	    	if(operand.indexOf("M(R0+") == 0 || operand.indexOf("M(R1+") == 0 
			|| operand.indexOf("M(R2+") == 0 || operand.indexOf("M(R3+") == 0){	// 必ず『M(#Rd+#n』で始まって
				if(operand.indexOf(")") == (operand.length() -1)){	// 必ず『)』で終わる
					return 1;
				}
				} 

		/*	if(operand.indexOf("M(") == 0){	// 必ず『M(』で始まって
				if(operand.indexOf("+R0)") == (operand.length() -1)||operand.indexOf("+R1)") == (operand.length() -1)||operand.indexOf("+R2)") == (operand.length() -1)||operand.indexOf("+R3)") == (operand.length() -1)){	// 必ず『#n+Rd)』で終わる
					return 1;
				}
				} //鈴木国松が変更  */
		
		return -1;	// ↑の条件に引っかからない＝エラーなので-1返す
	}	// check_memory_Rd_im()ここまで
	
	public static String rd_byte(String rd){//rdを２進数で返す
		String s;
		if(rd.equals("R0")){s="00";
		}else if(rd.equals("R1")){s="01";
		}else if(rd.equals("R2")){s="10";
		}else if(rd.equals("R3")){s="11";
		}else{s="";	}
				return s;
	}
	


	public static String ch_byte(int line){ //数字を２進数8桁にするメソ
		String s=Integer.toBinaryString(line);
		while(s.length()<8){
			s="0"+s;
		}
		while(s.length()>8){
			if(s.indexOf("1") == 0){
				s=s.replace("1","");
			}else{
				break;
			}
		}
		
		return s;
	}
	
	public static String n_byte(String nm){ //#nを２進数にする
		String s;
		int ss=-1;
		if(nm.indexOf("#") == 0){
		
			nm=nm.replaceFirst("#","");
			if(nm.indexOf("'") == 0){
				nm=nm.replace("'","");
				char[] charArray = nm.toCharArray();
				if(nm.equals("") ){
				}else{
					ss=charArray[0];
				}
			}else{
				try{
					ss=Integer.parseInt(nm);
				}catch (NumberFormatException e) {
		
				}
			}
	
			
		}else{ //アドレスの場合
			ss=line_nm(nm);
		}
		
		s=Integer.toBinaryString(ss);
	
		while(s.length()<8){
			s="0"+s;
		}
		while(s.length()>8){
			if(s.indexOf("1") == 0){
				s=s.replaceFirst("1","");
			}else{
				break;
			}
		}
		return s;
	}
	
	public static String m_byte(String mem){//メモリのアドを２進に
		String s;
		mem=mem.replace("M(","");
		mem=mem.replace(")","");
		s=Integer.toBinaryString(line_nm(mem));
		while(s.length()<8){
			s="0"+s;
		}
		while(s.length()>8){
			if(s.indexOf("1") == 0){
				s=s.replaceFirst("1","");
			}else{
				break;
			}
		}
		return s;
	}
	
	public static String m_byte_b(String mem){ //M(Rd)もしくはM(Rd+#n)ｗｐ２進に
		String s;
		mem=mem.replace("M(","");
		mem=mem.replace(")","");		
		if(mem.indexOf("+") == -1){
			s=rd_byte(mem)+" 00000000";
		}else{
			String str[]=mem.split("\\+");
			s=rd_byte(str[0]);
			if(str.length==2)
				s+= " "+n_byte(str[1]);
		}
		return s;
	}
	
	public static String line_byte(String line){//ラベルのアドを二進で返す
		String s;
		s=Integer.toBinaryString(line_nm(line));
		while(s.length()<8){
			s="0"+s;
		}
		return s; 
	}
	

	
	public static int line_nm(String line){ //ラベルのアドを返す
		int s=-1;
		for(int i=0;i<set.OpLineCount;i++){
			if(line.equals(set.L_label[i])){
				s=i;
			}
		}
		for(int i=0;i<set.LaLineCount;i++){
			if(line.equals(set.add_label[i])){
				s=i+set.OpLineCount;
			}
		}
		return s;
	}
	
	public static String ch_n(String n){
		String str="あ";
		if(n.indexOf("#") == 0){
			if((n.indexOf("'")==1 && n.indexOf("'",2)==3 && n.length()==4)){//文字の時
			
				str=n.replace("'","");
				str=str.replaceFirst("#","");
				byte[] asciiCodes;
				try {
					asciiCodes = str.getBytes("US-ASCII");
					int b = asciiCodes[0] & 0xff;
					str = "#"+String.valueOf(b);
				} catch (Exception e) {
					str="あ";
				}
				
			
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\n")==2&& n.length()==5 ){//\nのとき
				str="#10"; //野村ここから、エラー処理
			}	
			else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\0")==2&& n.length()==5 ){//NULLのとき
				str="";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\a")==2&& n.length()==5){//\aのとき
				str="#7";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\b")==2&& n.length()==5){//\bのとき
				str="#8";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\t")==2&& n.length()==5 ){//\tのとき
				str="#9";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\v")==2&& n.length()==5){//\vのとき
				str="#11";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\f")==2&& n.length()==5 ){//\fのとき
				str="#12";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\r")==2&& n.length()==5 ){//\rのとき
				str="#13";
			}else if(n.indexOf("'")==1 &&  n.indexOf("'",2)==4 && n.indexOf("\\e")==2&& n.length()==5 ){//\eのとき
				str="#27";
			}//野村ここまで
			else if(n.matches("#-?[0-9]+")){
				str=n.replaceFirst("#","");
				try{
					int k;
					k=Integer.parseInt(str);
					str=n;
					if(k>127 || k<-128){
						str="い";
					}
					
				}catch (NumberFormatException e) {
					str="い";
				}	
				
			}
		}else if(line_nm(n)!=-1){
				str=String.valueOf(line_nm(n));
		}
		

		return str;
	}
	
	public static int ch_char_st(String label,String value,int line){ //メモリの文字列を文字に直す
		int i=line;
		int k=0;
		value=value.replace("\"","");
		char ch[]=value.toCharArray();
	
		int a=0;
		int j=line+value.length();
		set.add_label[i]=label;
		while(i<j && k<ch.length){
			if(ch[k]=='\\' && k+1<ch.length ){
				if(ch[k+1]=='n' || ch[k+1]=='0' || ch[k+1]=='a' 
						|| ch[k+1]=='b' || ch[k+1]=='t' || ch[k+1]=='v' 
						|| ch[k+1]=='f' || ch[k+1]=='r' || ch[k+1]=='e'){
					set.add_value[i]=ch_n("#'"+String.valueOf(ch[k])+String.valueOf(ch[k+1])+"'");
					k+=2;
				}	
			}else{
				set.add_value[i]=ch_n("#'"+String.valueOf(ch[k])+"'");
				k++;
			}
			a++;
			i++;
		}
		return a;
	}
	
	public static String ch_M_add(String mem){ //M(ad)の行数を返す（OpLineCount-LaLineCount）
		String str="";
		int i;
		mem=mem.replace("M(", "");
		mem=mem.replace(")", "");
		for(i=0;i<set.LaLineCount;i++){
			if(set.add_label[i].equals(mem)&&set.add_label[i].equals("")==false){
				str=String.valueOf(i+set.OpLineCount);
			}
		}
		
		return str;
	}
	
	public static String ch_M_Rdnn(String mem){ //M(Rd+#n)の＃ｎを行数で返す(OpLineCount-set.LaLineCount)
		String str="";
		if(check_memory_Rd_im(mem)==1){
			String[] strAry = mem.split("\\+");
			if(strAry[1].indexOf("#") == 0){		 //#nの処理	
				strAry[1]=strAry[1].replace("#", "");
				strAry[1]=strAry[1].replace(")", "");
				str=strAry[1];
			}else{
				strAry[1]=strAry[1].replace(")", "");
				str=String.valueOf(line_nm(strAry[1]));
			}
		}else{
			
		}
		return str;	
	}
	
	public static String ch_M_RdnR(String mem){ //M(Rd+#n)noのRdを返す
		String str="";
		if(check_memory_Rd_im(mem)==1){
			String[] strAry = mem.split("\\+");
			str=strAry[0].replace("M(", "");
		}
		
		return str;
	}
	
	public static String ch_M_Rd(String mem){//M(Rd)のRdを返す
		String str="";
		str=mem.replace("M(", "");
		str=str.replace(")", "");
		return str;
	}
	
	
		
	// check_opcode_and_operand(set.L[i], i):オペコードやオペランドのコンパイルエラー？をチェックする関数 input()で使用
	public static void check_opcode_and_operand(int op_code, String op_1, String op_2, String op_3, int now_line){
		int op_code_no;
		
		op_code_no = op_code;	
		
		switch(op_code_no){
			case set.Load_I:
					if(check_register(op_1) != 1){	// オペランドがレジスタかチェックする関数
						main.error("LOADIの第1オペランドはレジスタです", now_line);
					}
					if(op_2.compareTo("") == 0 ){	// オペランドが即値かチェックする関数
						main.error("LOADIの第2オペランドは即値です", now_line);
					}
					if(op_3.compareTo("") != 0)	{	// ROADIは第3オペランド使わない
						main.error("LOADIの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Load_I;
					set.act_r1[now_line] = op_1;
					set.act_n[now_line] = ch_n(op_2);
					set.act_real_L[now_line] = now_line;
					System.out.println("aa "+ch_n(op_2));
					if( ch_n(op_2).equals("あ")){	// オペランドが即値かチェックする関数					
						main.error("LOADIの第2オペランドは即値です", now_line);
						set.check_flag=1;
					}
					if( ch_n(op_2).equals("い")){	// オペランドが即値かチェックする関数					
						set.check_flag=1;
						main.error("使用できる数字は-128〜127の整数です", now_line);
					}
					if(set.check_flag==0){
						String a=set.act_n[now_line];
						if(a.indexOf("#")==0){
						}else{
							a="#"+a;
						}
								
						set.output_binary_string+= ch_byte(now_line) +" 0000 "+
								rd_byte(op_1)+" "+n_byte(a)+" 00\n";
					}
					break;
					
			case set.Load_A:
					if(check_register(op_1) != 1){
						main.error("LOADAの第1オペランドはレジスタです", now_line);
					}
					if(check_memory_ad(op_2)!= 1  || check_memory_Rd(op_2)==1){
						main.error("LOADAの第2オペランドは M(addres) です", now_line);
					}
					if(ch_M_add(op_2).equals("")){
						main.error("LOADAの第2オペランドは M(addres) です", now_line);
						set.check_flag=1;
					}
					if(op_3.compareTo("") != 0)	{	// ROADAは第3オペランド使わない
						main.error("LOADAの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Load_A;
					set.act_r1[now_line] = op_1;
					set.act_n[now_line] = ch_M_add(op_2);
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0001 "+
												rd_byte(op_1)+" "+m_byte(op_2)+" 00\n";
					
					break;
			
			case set.Load_X:
					if(check_register(op_1) != 1){
						main.error("LOADXの第1オペランドはレジスタです", now_line);
				
					}
					if(check_memory_Rd_im(op_2) ==  -1 &&  check_memory_Rd(op_2) == -1){
						main.error("LOADXの第2オペランドは  M(Rd) または M(Rs+#n)です", now_line);
						set.check_flag=6;
					}
					if(op_3.compareTo("") != 0)	{	// ROADXは第3オペランド使わない
						main.error("LOADXの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Load_X;
					set.act_r1[now_line] = op_1;
					if(check_memory_Rd_im(op_2)==1){
						set.act_n[now_line] = ch_M_Rdnn(op_2);
						set.act_r2[now_line] = ch_M_RdnR(op_2);
					}else{
						set.act_n[now_line] = "0";
						set.act_r2[now_line] = ch_M_Rd(op_2);
					}
					set.act_real_L[now_line] = now_line;
					
				
					if(set.act_n[now_line].equals("")){
						main.error("LOADXの第2オペランドは M(Rd) または M(Rd+#n) です", now_line);
						set.check_flag=7;
						break;
					}
				
					set.output_binary_string+= ch_byte(now_line) +" 0010 "+
							rd_byte(op_1)+" "+m_byte_b(op_2)+"\n";
					break;
			
			case set.Store_A:
					if(check_memory_ad(op_1) != 1 ||check_memory_Rd(op_1)==1){
						main.error("STOREAの第1オペランドは M(addres) です", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("STOREAの第2オペランドはレジスタです", now_line);
					}
					if(ch_M_add(op_1).equals("")){
						main.error("STOREAの第1オペランドは M(addres) です", now_line);
						set.check_flag=1;
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("STOREAの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Store_A;
					set.act_n[now_line] = ch_M_add(op_1);
					set.act_r1[now_line] = (op_2);
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0011 "+
												m_byte(op_1)+" "+rd_byte(op_2)+" 00\n";
					
					break;
					
			case set.Store_X:
					if(check_memory_Rd(op_1) != 1 && check_memory_Rd_im(op_1) != 1){
						main.error("STOREXの第1オペランドは M(Rd) または M(Rd+#n) です", now_line);
						set.check_flag=7;
					}
					if(check_register(op_2) != 1){
						main.error("STOREXの第2オペランドはレジスタです", now_line);
						
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("STOREAの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Store_X;
				
					set.act_r1[now_line] = op_2;
					if(check_memory_Rd_im(op_1)==1){
						set.act_n[now_line] = ch_M_Rdnn(op_1);
						set.act_r2[now_line] = ch_M_RdnR(op_1);
					}else{
						set.act_n[now_line] = "0";
						set.act_r2[now_line] = ch_M_Rd(op_1);
					}
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0100 "+
												m_byte_b(op_1)+" "+rd_byte(op_2)+"\n";
					if(set.act_n[now_line].equals("")){
						main.error("STOREXの第1オペランドは M(Rd) または M(Rd+#n) です", now_line);
						set.check_flag=7;
					}
					
					break;
					
			case set.Add:
					if(check_register(op_1) != 1){
						main.error("ADDの第1オペランドはレジスタです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("ADDの第2オペランドはレジスタです", now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("ADDの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Add;
					set.act_r1[now_line] = op_1;
					set.act_r2[now_line] = op_2;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0101 "+
												rd_byte(op_1)+" " +rd_byte(op_2)+" 00000000\n";
					
					break;	

			case set.Sub:
					if(check_register(op_1) != 1){
						main.error("SUBの第1オペランドはレジスタです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("SUBの第2オペランドはレジスタです", now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("SUBの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Sub;
					set.act_r1[now_line] = op_1;
					set.act_r2[now_line] = op_2;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0110 "+
												rd_byte(op_1)+" " +rd_byte(op_2)+" 00000000\n";
					
					break;	

			case set.Inc:
					if(check_register(op_1) != 1){
						main.error("INCの第1オペランドはレジスタです", now_line);
					}
					if(op_2.compareTo("") != 0)	{	// STOREAは第2オペランド使わない
						main.error("INCの第2オペランドは使用しません",now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("INCの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Inc;
					set.act_r1[now_line] = op_1;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 0111 "+
												rd_byte(op_1)+" 0000000000\n";
					
					break;	

			case set.Dec:
					if(check_register(op_1) != 1){
						main.error("DECの第1オペランドはレジスタです", now_line);
					}
					if(op_2.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("DECの第2オペランドは使用しません",now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("DECの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Dec;
					set.act_r1[now_line] = op_1;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1000 "+
												rd_byte(op_1)+" 0000000000\n";
					
					break;	
			
			case set.Br_Gt:
					if(check_register(op_1) != 1){
						main.error("BRGTの第1オペランドはレジスタです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("BRGTの第2オペランドはレジスタです", now_line);
					}
					if(op_3.equals("")||line_nm(op_3)==-1){ ;
						main.error("BRGTの第3オペランドはラベルです", now_line);
						set.check_flag=8;
					}
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Br_Gt;
					set.act_r1[now_line] = op_1;
					set.act_r2[now_line] = op_2;
					set.act_n[now_line] = String.valueOf(line_nm(op_3));
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1001 "
												+rd_byte(op_1)+" "+rd_byte(op_2)+" "+line_byte(op_3)+"\n";
					
					break;

			case set.Br_Eq:
					if(check_register(op_1) != 1){
						main.error("BREQの第1オペランドはレジスタです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("BREQの第2オペランドはレジスタです", now_line);
					}
					if(op_3.equals("")||line_nm(op_3)==-1)	{	
						main.error("BREQの第3オペランドはラベルです",now_line);
						set.check_flag=9;
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Br_Eq;
					set.act_r1[now_line] = op_1;
					set.act_r2[now_line] = op_2;
					set.act_n[now_line] = String.valueOf(line_nm(op_3));
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1010 "+
											rd_byte(op_1)+" "+rd_byte(op_2)+" "+line_byte(op_3)+"\n";			
					break;

			case set.Br_Lt:
					if(check_register(op_1) != 1){
						main.error("BRLTの第1オペランドはレジスタです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("BRLTの第2オペランドはレジスタです", now_line);
					}
					if(op_3.equals("")||line_nm(op_3)==-1)	{	
						main.error("BRLTの第3オペランドはラベルです",now_line);
						set.check_flag=10;
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Br_Lt;
					set.act_r1[now_line] = op_1;
					set.act_r2[now_line] = op_2;
					set.act_n[now_line] = String.valueOf(line_nm(op_3));
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1011 "
										+rd_byte(op_1)+" "+rd_byte(op_2)+" "+line_byte(op_3)+"\n";
					
					break;

			case set.Br_A:
					if(op_1.equals("")||line_nm(op_1)==-1){
						main.error("BRAの第1オペランドはラベルです",now_line);
						set.check_flag=11;
					}
					if(op_2.compareTo("") != 0)	{	// STOREAは第2オペランド使わない
						main.error("BRAの第2オペランドは使用しません",now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("BRAの第3オペランドは使用しません",now_line);
					}
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Br_A;
					set.act_n[now_line] = String.valueOf(line_nm(op_1));
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1100 "+
													line_byte(op_1)+" 0000\n";
					
					break;	
					
			case set.Br_R:
					if(check_register(op_1) != 1){
						main.error("BRRの第1オペランドはレジスタです",now_line);
					}
					if(op_2.compareTo("") != 0)	{	// STOREAは第2オペランド使わない
						main.error("BRAの第2オペランドは使用しません",now_line);
					}
					if(op_3.compareTo("") != 0)	{	// STOREAは第3オペランド使わない
						main.error("BRAの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Br_R;
					set.act_r1[now_line] = op_1;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1101 "+
												rd_byte(op_1)+" 0000000000\n";
					
					break;
					
			case set.Call:
					if(op_1.compareTo("DISPLAY") != 0 && op_1.compareTo("INPUT") != 0){
						main.error("CALLの第1オペランドは  DISPLAY か INPUT のいずれかです", now_line);
					}
					if(check_register(op_2) != 1){
						main.error("CALLの第2オペランドはレジスタです", now_line);
					}
					if(op_3.compareTo("") != 0)	{	
						main.error("CALLの第3オペランドは使用しません",now_line);
					}
					
					/* 問題なければaction_L[] に代入して終了*/
					set.act_op_code[now_line] = set.Call;
					if(op_1.compareTo("INPUT") == 0){ 
						set.act_code[now_line] = 1;
					}
					if(op_1.compareTo("DISPLAY") == 0){ 
						set.act_code[now_line] = 0;
					}
					set.act_r1[now_line] = op_2;
					set.act_real_L[now_line] = now_line;
								
					set.output_binary_string+= ch_byte(now_line) +" 1110 0"+
												set.act_code[now_line]+" "+rd_byte(op_2)+" 00000000\n";
					
					break;
				
					
			case set.Hlt:
					if(op_1.compareTo("") != 0)	{	
						main.error("HLTの第1オペランドは使用しません",now_line);
					}
					if(op_2.compareTo("") != 0)	{	
						main.error("HLTの第2オペランドは使用しません",now_line);
					}
					if(op_3.compareTo("") != 0)	{	
						main.error("HLTの第3オペランドは使用しません",now_line);
					}
					
					set.act_op_code[now_line] = set.Hlt;
					set.act_real_L[now_line] = now_line;
					
					set.output_binary_string+= ch_byte(now_line) +" 1111 000000000000"+"\n";
				
					break;
			default:
				   
				    break;			
		}
	}	
	
	
	public static void input_address(){
		int i = 0;
		set.output_binary_string += "\n";
		while(true){
			// 出力用文字列に追加していく	
			if(i>=set.LaLineCount){
				break;
			}
			int s=i+set.OpLineCount;
			if(set.add_comment[i].equals("")==false){
				set.add_comment[i]=" //"+set.add_comment[i];
			}
			String str_value=set.add_value[i];
			if(set.add_value[i].indexOf("#") == 0 ){
				str_value=set.add_value[i].replace("#","");
				str_value=str_value.replace("'","\"");
			}
			String str_opc = set.add_label[i];
			if(set.add_label[i].equals("")==false){
				str_opc=set.add_label[i]+":";
			}
			
			set.input_program_string +=  str_opc+ " " + str_value +set.add_comment[i]+ "\n";
			if(n_byte(set.add_value[i]).equals("11111111")==false ){
				System.out.println(set.add_value[i]);
				set.output_binary_string += ch_byte(s)+" "+ n_byte(set.add_value[i]) +"\n";
			}
			//}
			if(set.add_label[i].equals("ありえないかずとか")){	// ラベル入ってない==空行ならそこで入力おしまいなのでbreakして抜ける
				break;
			}
			i++;	
		}
	}
	
	public static String input_asse(int op){
		int op_code_no=op;
		
		switch(op_code_no){
		case set.Load_I:return "LOADI";
		case set.Load_A:return "LOADA";
		case set.Load_X:return "LOADX";
		case set.Store_A:return "STOREA";
		case set.Store_X:return "STOREX";
		case set.Add:return "ADD";
		case set.Sub:return "SUB";
		case set.Inc:return "INC";
		case set.Dec:return "DEC";
		case set.Br_Gt:return "BRGT";
		case set.Br_Eq:return "BREQ";
		case set.Br_Lt:return "BRLT";
		case set.Br_A:return "BRA";
		case set.Br_R:return "BRR";
		case set.Call:return "CALL";
		case set.Hlt:return "HLT";
		default: return "";
		}
	}

	public static void input_a(){
	
			
		if(set.m_time_str.equals("")){ //メモリアクセス時間の秒数
				
		}else{
			if(set.m_time_str.matches("[0-9]+")){
				set.m_time=Long.parseLong(set.m_time_str);
			}
		}	
		
		if(set.option_set_M==true){ //メモリアクセス時間を待つかどうか
			set.m_time=0;
		}
		
		
		for(int k=0;k<set.assembler_total_length;k++){
			used_label[k]="ありえないかずとか";
		}
		
		
		//ここに行数カウント追加する！
		int count=0;	//なにもオペコードにはいってなければ命令部は０行
		for(int j=1;j<=set.OpLAYOUT_MAX_NUM;j++){
			if(set.L_op_code[j-1]!=16){
				count=j;
			}
		}
		set.OpLineCount=count;
		set.LaLineCount=set.assembler_length-count;
		
		
		
		
		//メモリの文字列処理
		int l=0;
		for(int k=0;k<set.LaLineCount;k++){
			if(set.L_add_value[l].equals("")){
				set.add_value[k]=set.L_add_value[l];
				set.add_label[k]=set.L_add_label[l];
			}else{
				if(set.L_add_value[l].indexOf("\"")==0 &&
						set.L_add_value[l].endsWith("\"")==true &&
						set.L_add_value[l].length()>=3){
					k+=ch_char_st(set.L_add_label[l],set.L_add_value[l],k)-1;
				}else if(set.L_add_value[l].matches("-?[0-9]+")){
					try{
						int a;
						a=Integer.parseInt(set.L_add_value[l]);
						if(a<=127 && a>=-128){
							set.add_value[k]="#"+set.L_add_value[l];
							set.add_label[k]=set.L_add_label[l];
						}else{
							main.error("使用できる数字は-128〜127の整数です", set.OpLineCount+l);
							set.check_flag=1;	
							set.add_label[k]=set.L_add_label[l];
						}
						
					}catch (NumberFormatException e) {
						main.error("使用できる数字は-128〜127の整数です", set.OpLineCount+l);
						set.check_flag=1;	
					}	
					
					
				}else{
					main.error("メモリに入力できるのは文字列か数字です", set.OpLineCount+l);
					set.check_flag=1;				
				}
			}
			l++;
		}
		
		/* 1行分ずつ読み込んでいって、エラー処理ここでしておく。 */ 
		int i=0;
		while(true){
			if(i>=set.OpLineCount) break;
			check_used_label(set.L_label[i], i);	// 使用済みラベルを使っていないかチェック
			check_opcode_and_operand(set.L_op_code[i], set.L_operand_1[i], set.L_operand_2[i], set.L_operand_3[i], i);		// 指定されたオペコードとオペランドの入力エラーチェック
		
			
			/* ここで、入力プログラム出力用の文字列に一気に放り込む */ 
			if(set.L_op_code[i]!=set.Sp){
				if(set.L_comment[i].equals("")==false){
					set.L_comment[i]="//"+set.L_comment[i];
				}
				String str_opc = set.L_label[i];
				if(set.L_label[i].equals("")==false){
					str_opc=set.L_label[i]+":";
				}
				set.input_program_string +=str_opc + " "
									 + input_asse(set.L_op_code[i]) + " "
									 + set.L_operand_1[i] + " "
									 + set.L_operand_2[i] + " "
									 + set.L_operand_3[i] + " "
									 + set.L_comment[i] 
									 + "\n" ;
			}
			
			
			i ++;	// ループ回す為に増やす（i行目
			
		}	// 入力プログラム出力用の文字列に一気に放り込む ここまで
		for(i=0;i<set.LaLineCount;i++){
			check_used_label(set.L_add_label[i], i+set.OpLineCount);
		}
		if(	set.check_flag==0)
			input_address();	// アドレス領域のデータを放り込む
	}	
}
